# Microsoft Azure AD Groups by Graph

> Note: The use of the scripts requires the PowerShell Microsoft.Graph.Groups

+ [Add-MGGGroupToLifecyclePolicy.ps1](./Add-MGGGroupToLifecyclePolicy.ps1)

  Adds group to Lifecycle Policy

+ [Get-MGGAllGroupSite.ps1](./Get-MGGAllGroupSite.ps1)

  Invoke function getAllSites

+ [Get-MGGGroup.ps1](./Get-MGGGroup.ps1)

  Returns a Group

+ [Get-MGGGroupAcceptedSender.ps1](./Get-MGGGroupAcceptedSender.ps1)

  Users in the accepted senders list can post to conversations of the group (identified in the GET request URL)

+ [Get-MGGGroupAcceptedSenderCount.ps1](./Get-MGGGroupAcceptedSenderCount.ps1)

  Get the number of the resource

+ [Get-MGGGroupConversation.ps1](./Get-MGGGroupConversation.ps1)

  Group's conversations
  
+ [Get-MGGGroupConversationCount.ps1](./Get-MGGGroupConversationCount.ps1)

  Get the number of the resource

+ [Get-MGGGroupConversationThread.ps1](./Get-MGGGroupConversationThread.ps1)

  Collection of all the conversation threads in the conversation

+ [Get-MGGGroupConversationThreadCount.ps1](./Get-MGGGroupConversationThreadCount.ps1)

  Get the number of the resource

+ [Get-MGGGroupConversationThreadPost.ps1](./Get-MGGGroupConversationThreadPost.ps1)

  Gets conversation thread post

+ [Get-MGGGroupConversationThreadPostCount.ps1](./Get-MGGGroupConversationThreadPostCount.ps1)

  Get the number of the resource

+ [Get-MGGGroupCount.ps1](./Get-MGGGroupCount.ps1)

  Get the number of the resource

+ [Get-MGGGroupCreatedOnBehalfOf.ps1](./Get-MGGGroupCreatedOnBehalfOf.ps1)

  The user (or application) that created the group

+ [Get-MGGGroupDelta.ps1](./Get-MGGGroupDelta.ps1)

  Invoke function delta

+ [Get-MGGGroupExtension.ps1](./Get-MGGGroupExtension.ps1)

  Gets a collection of open extensions defined for the group

+ [Get-MGGGroupExtensionCount.ps1](./Get-MGGGroupExtensionCount.ps1)

  Get the number of the resource

+ [Get-MGGGroupLifecyclePolicy.ps1](./Get-MGGGroupLifecyclePolicy.ps1)

  Retrieve the properties and relationships of a groupLifecyclePolicies object

+ [Get-MGGGroupLifecyclePolicyCount.ps1](./Get-MGGGroupLifecyclePolicyCount.ps1)

  Get the number of the resource

+ [Get-MGGGroupMember.ps1](./Get-MGGGroupMember.ps1)

  Returns members from a Group
  
+ [Get-MGGGroupMemberCount.ps1](./Get-MGGGroupMemberCount.ps1)

  Get the number of the resource

+ [Get-MGGGroupMemberGroup.ps1](./Get-MGGGroupMemberGroup.ps1)

  Return all the group IDs for the groups that the specified user, group, service principal, organizational contact, device, or directory object is a member of

+ [Get-MGGGroupMemberObject.ps1](./Get-MGGGroupMemberObject.ps1)

  Return all the group IDs for the groups that the specified user, group, service principal, organizational contact, device, or directory object is a member of

+ [Get-MGGGroupMemberOf.ps1](./Get-MGGGroupMemberOf.ps1)

  Groups that this group is a member of

+ [Get-MGGGroupMemberOfCount.ps1](./Get-MGGGroupMemberOfCount.ps1)

Get the number of the resource

+ [Get-MGGGroupMemberWithLicenseError.ps1](./Get-MGGGroupMemberWithLicenseError.ps1)

  Returns group members with license errors

+ [Get-MGGGroupMemberWithLicenseErrorCount.ps1](./Get-MGGGroupMemberWithLicenseErrorCount.ps1)

  Get the number of the resource

+ [Get-MGGGroupOnenoteNotebookFromWebUrl.ps1](./Get-MGGGroupOnenoteNotebookFromWebUrl.ps1)

  Get group notebook from web url

+ [Get-MGGGroupOwner.ps1](./Get-MGGGroupOwner.ps1)

  Returns owners from a Group

+ [Get-MGGGroupOwnerCount.ps1](./Get-MGGGroupOwnerCount.ps1)

  Get the number of the resource

+ [Get-MGGGroupPermissionGrant.ps1](./Get-MGGGroupPermissionGrant.ps1)

  Gets the permission that has been granted for a group

+ [Get-MGGGroupPhoto.ps1](./Get-MGGGroupPhoto.ps1)

  The group's profile photo

+ [Get-MGGGroupPhotoContent.ps1](./Get-MGGGroupPhotoContent.ps1)

  Get media content for the navigation property photo from groups

+ [Get-MGGGroupRejectedSender.ps1](./Get-MGGGroupRejectedSender.ps1)

  Gets a list of users or groups that are not allowed to create posts or calendar events in this group

+ [Get-MGGGroupRejectedSenderCount.ps1](./Get-MGGGroupRejectedSenderCount.ps1)

  Get the number of the resource

+ [Get-MGGGroupSetting.ps1](./Get-MGGGroupSetting.ps1)

  Retrieve the properties of a specific group setting object

+ [Get-MGGGroupSettingCount.ps1](./Get-MGGGroupSettingCount.ps1)

  Get the number of the resource

+ [Get-MGGGroupThread.ps1](./Get-MGGGroupThread.ps1)

  Group's conversation threads

+ [Get-MGGGroupThreadPost.ps1](./Get-MGGGroupThreadPost.ps1)

  Group's thread post

+ [Get-MGGGroupTransitiveMember.ps1](./Get-MGGGroupTransitiveMember.ps1)

  The direct and transitive members of a group

+ [Get-MGGGroupTransitiveMemberCount.ps1](./Get-MGGGroupTransitiveMemberCount.ps1)

  Get the number of the resource

+ [Get-MGGGroupTransitiveMemberOf.ps1](./Get-MGGGroupTransitiveMemberOf.ps1)

  The groups that a group is a member of, either directly or through nested membership

+ [Get-MGGGroupTransitiveMemberOfCount.ps1](./Get-MGGGroupTransitiveMemberOfCount.ps1)

  Get the number of the resource

+ [Invoke-MGGRenewGroup.ps1](./Invoke-MGGRenewGroup.ps1)

  Invokes renew a Group

+ [New-MGGGroup.ps1](./New-MGGGroup.ps1)

  Creates a Group

+ [New-MGGGroupExtension.ps1](./New-MGGGroupExtension.ps1)

  Create collection of open extensions defined for the group

+ [New-MGGGroupLifecyclePolicy.ps1](./New-MGGGroupLifecyclePolicy.ps1)

  Add new entity to group Lifecycle Policy

+ [New-MGGGroupMember.ps1](./New-MGGGroupMember.ps1)

  Add member to a Group

+ [New-MGGGroupOwner.ps1](./New-MGGGroupOwner.ps1)

  Add owner to a Group

+ [Remove-MGGGroup.ps1](./Remove-MGGGroup.ps1)

  Removes a Group

+ [Remove-MGGGroupExtension.ps1](./Remove-MGGGroupExtension.ps1)

  Removes a collection of open extensions defined for the group

+ [Remove-MGGGroupFromLifecyclePolicy.ps1](./Remove-MGGGroupFromLifecyclePolicy.ps1)

  Removes group from Lifecycle Policy

+ [Remove-MGGGroupLifecyclePolicy.ps1](./Remove-MGGGroupLifecyclePolicy.ps1)

  Remove group Lifecycle Policy

+ [Remove-MGGGroupPhoto.ps1](./Remove-MGGGroupPhoto.ps1)

  Delete navigation property photo for groups

+ [Reset-MGGGroupUnseenCount.ps1](./Reset-MGGGroupUnseenCount.ps1)

  Invoke action resetUnseenCount

+ [Set-MGGGroup.ps1](./Set-MGGGroup.ps1)

  Updates a Group

+ [Set-MGGGroupExtension.ps1](./Set-MGGGroupExtension.ps1)

  Updates a collection of open extensions defined for the group

+ [Set-MGGGroupLifecyclePolicy.ps1](./Set-MGGGroupLifecyclePolicy.ps1)

  Update entity in group Lifecycle Policy

+ [Set-MGGGroupPhotoContent.ps1](./Set-MGGGroupPhotoContent.ps1)

  Update media content for the navigation property photo in groups

+ [Test-MGGGroupProperty.ps1](./Test-MGGGroupProperty.ps1)
  
  Invoke action validateProperties

## [Queries](./_QUERY_)

  + Search groups
  + Search security groups
  + Search conversations
  + Search conversation threads
  + Search conversation thread posts 